<?php
/**
 * ربات دانلود اینستاگرام تلگرام
 * 
 * @author   mahan Developer
 * @contact  https://t.me/lostmahan
 * @version  3.0.0
 * @date     2025-07-27
 * @license  Private Use Only - Do Not Distribute
 */

$botToken = "8405631299:AAFiFPPbkXpCWd9fDYgNTnNENl66Me4W08s"; //توکنتو اینجا بزار
$apiKey = "1482706652:3Bv7ILCJudlDAZp@Api_ManagerRoBot";
$fastCreateApi = "https://api.fast-creat.ir/instagram";
$admin_id = 7952193354; // ایدی عددی ادمین رو اینجا بزار
$channelUsername = "@Team_Vector"; // 👈 یوزرنیم کانال شما



$update = json_decode(file_get_contents('php://input'), true);

if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];


    
if ($message['chat']['type'] === "private") {
    if (!isUserJoined($chatId, $channelUsername) && $chatId != $admin_id) {
        $joinText = "🔒 برای استفاده از ربات ابتدا در کانال ما عضو شوید:";
        $keyboard = [
            [
                ["text" => "📢 عضویت در کانال", "url" => "https://t.me/InstaSaverAi"]
            ],
            [
                ["text" => "✅ عضو شدم", "callback_data" => "check_join"]
            ]
        ];
        sendMessage($chatId, $joinText, $keyboard, true);
        exit();
    }
}


    saveUser($chatId);
}

if (isset($update['callback_query'])) {
    $callback = $update['callback_query'];
    $chatId = $callback['message']['chat']['id'];
    $data = $callback['data'];

if ($data == "check_join") {
    if (isUserJoined($chatId, "$channelUsername")) {
        answerCallbackQuery($callback['id'], "✅ شما عضو شدید!");
        sendMessage($chatId, "✅ با موفقیت عضو شدید، حالا می‌تونید از ربات استفاده کنید.");
    } else {
        answerCallbackQuery($callback['id'], "⛔️ هنوز عضو نشدید!");
        sendMessage($chatId, "⛔️ هنوز در کانال عضو نیستید. لطفا ابتدا عضو شوید و دوباره تلاش کنید.");
    }
    exit();
}




    if ($chatId == $admin_id) {
        switch ($data) {
            case "stats":
                $users = file_exists('users.txt') ? file('users.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
                $count = count($users);
                $text = "📊 تعداد کاربران ثبت شده: $count";
                answerCallbackQuery($callback['id'], $text);
                sendMessage($chatId, $text);
                break;

            case "broadcast":
                answerCallbackQuery($callback['id'], "لطفا پیام همگانی را ارسال کنید:");
                // اینجا باید حالت دریافت پیام برای همگانی رو مدیریت کنی (حالت بعدی در برنامه)
                file_put_contents("broadcast_state.txt", "on_$chatId"); // حالت ساده برای مثال
                break;

            case "forward_all":
                answerCallbackQuery($callback['id'], "لطفا پیام برای فوروارد به همه ارسال کنید:");
                file_put_contents("forward_state.txt", "on_$chatId");
                break;

            case "block_user":
                answerCallbackQuery($callback['id'], "لطفا ایدی کاربر برای بلاک وارد کنید:");
                file_put_contents("block_state.txt", "on_$chatId");
                break;

            case "unblock_user":
                answerCallbackQuery($callback['id'], "لطفا ایدی کاربر برای آنبلاک وارد کنید:");
                file_put_contents("unblock_state.txt", "on_$chatId");
                break;

            case "bot_on":
                answerCallbackQuery($callback['id'], "ربات روشن شد.");
                file_put_contents("bot_status.txt", "on");
                break;

            case "bot_off":
                answerCallbackQuery($callback['id'], "ربات خاموش شد.");
                file_put_contents("bot_status.txt", "off");
                break;

            case "back_to_home":
                answerCallbackQuery($callback['id']);
                sendAdminPanel($chatId);
                break;
        }
    }
    exit();
}

if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $text = isset($message['text']) ? trim($message['text']) : '';


if ($message['chat']['type'] !== "private") {
    if (strpos($text, "instagram.com") === false) {
        exit();
    }
}


    $botStatus = file_exists('bot_status.txt') ? trim(file_get_contents('bot_status.txt')) : "on";
    if ($botStatus == "off" && $chatId != $admin_id) {
        sendMessage($chatId, "ربات در حال حاضر خاموش است.");
        exit();
    }

    if ($chatId == $admin_id && in_array(strtolower($text), ['/admin', '/panel'])) {
        sendAdminPanel($chatId);
        exit();
    }

    if ($chatId == $admin_id) {
        if (file_exists("broadcast_state.txt")) {
            $state = trim(file_get_contents("broadcast_state.txt"));
            if ($state == "on_$chatId") {
                $users = file_exists('users.txt') ? file('users.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
                foreach ($users as $user) {
                    sendMessage($user, $text);
                }
                sendMessage($chatId, "پیام همگانی با موفقیت ارسال شد.");
                unlink("broadcast_state.txt");
                exit();
            }
        }
        if (file_exists("forward_state.txt")) {
            $state = trim(file_get_contents("forward_state.txt"));
            if ($state == "on_$chatId") {
                $users = file_exists('users.txt') ? file('users.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
                foreach ($users as $user) {
                    forwardMessage($user, $chatId, $message['message_id']);
                }
                sendMessage($chatId, "فوروارد پیام به همه کاربران انجام شد.");
                unlink("forward_state.txt");
                exit();
            }
        }
        if (file_exists("block_state.txt")) {
            $state = trim(file_get_contents("block_state.txt"));
            if ($state == "on_$chatId") {
                // ذخیره id کاربر بلاک شده
                $blockedUsers = file_exists('blocked.txt') ? file('blocked.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
                if (!in_array($text, $blockedUsers)) {
                    file_put_contents('blocked.txt', $text . PHP_EOL, FILE_APPEND);
                    sendMessage($chatId, "کاربر $text بلاک شد.");
                } else {
                    sendMessage($chatId, "این کاربر قبلاً بلاک شده.");
                }
                unlink("block_state.txt");
                exit();
            }
        }
        if (file_exists("unblock_state.txt")) {
            $state = trim(file_get_contents("unblock_state.txt"));
            if ($state == "on_$chatId") {
                $blockedUsers = file_exists('blocked.txt') ? file('blocked.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
                if (($key = array_search($text, $blockedUsers)) !== false) {
                    unset($blockedUsers[$key]);
                    file_put_contents('blocked.txt', implode(PHP_EOL, $blockedUsers) . PHP_EOL);
                    sendMessage($chatId, "کاربر $text آنبلاک شد.");
                } else {
                    sendMessage($chatId, "این کاربر بلاک نیست.");
                }
                unlink("unblock_state.txt");
                exit();
            }
        }
    }

    $blockedUsers = file_exists('blocked.txt') ? file('blocked.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
    if (in_array($chatId, $blockedUsers)) {
        sendMessage($chatId, "شما بلاک هستید و نمی‌توانید از ربات استفاده کنید.");
        exit();
    }

    if ($text === '/start') {
        sendMessage($chatId, "🔸سلام خوش آمدید ، لطفا لینک دانلود محتوای مورد نظر را برای ما ارسال کنید.");
        exit();
    }


if ($text === '/help') {
    $helpText = "✅ <b>راهنمای دانلود محتوا</b>\n\n⭐️ فقط کافیه لینک اینستاگرام رو بفرستی، همین!\nمثل این 👇\nhttps://www.instagram.com/p/abc123/";
    sendMessage($chatId, $helpText);
    exit();
}



    if (filter_var($text, FILTER_VALIDATE_URL)) {
        sendMessage($chatId, "⌛️لطفا کمی صبر کنید در حال دریافت اطلاعات هستیم.");

        $params = [
            'apikey' => $apiKey,
            'type' => 'post',
            'url' => $text,
        ];

        $url = $fastCreateApi . '?' . http_build_query($params);

        $response = file_get_contents($url);
        if ($response === false) {
            sendMessage($chatId, "خطا در ارتباط با API.");
            exit();
        }

        $data = json_decode($response, true);

if (
    isset($data['ok'], $data['result']['result']) &&
    $data['ok'] === true &&
    is_array($data['result']['result']) &&
    count($data['result']['result']) > 0
) {
    $firstItem = $data['result']['result'][0];
    $caption = !empty($firstItem['caption']) ? html_entity_decode($firstItem['caption'], ENT_QUOTES | ENT_HTML5, 'UTF-8') : '';


    if (!empty($firstItem['is_video']) && !empty($firstItem['video_url'])) {
        $videoUrl = $firstItem['video_url']; // لینک مستقیم ویدیو
    } else {
        sendMessage($chatId, "❌ ویدیویی پیدا نشد یا لینک معتبر نیست.");
        exit();
    }


            $tempFile = downloadFile($videoUrl);
            if (!$tempFile) {
                sendMessage($chatId, "خطا در دانلود ویدیو.");
                exit();
            }

            $filesizeMB = filesize($tempFile) / (1024 * 1024);
            if ($filesizeMB > 49) {
                sendMessage($chatId, "حجم ویدیو بیشتر از حد مجاز است. لینک مستقیم:\n$videoUrl");
                unlink($tempFile);
                exit();
            }

            $sendResult = sendVideoFile($chatId, $tempFile, $caption);

            unlink($tempFile);

            $resultData = json_decode($sendResult, true);
            if (!isset($resultData['ok']) || $resultData['ok'] !== true) {
                sendMessage($chatId, "خطا در ارسال ویدیو.");
            }
        } else {
            sendMessage($chatId, "ویدیویی یافت نشد یا لینک نامعتبر است.");
        }
    } else {
        sendMessage($chatId, "لطفا یک لینک اینستاگرام معتبر ارسال کنید.");
    }
}


function sendAdminPanel($chatId)
{
    sendMessage($chatId, "🎛 پنل مدیریت:", [
        [["text" => "📊 آمار", "callback_data" => "stats"]],
        [["text" => "📢 همگانی", "callback_data" => "broadcast"], ["text" => "🔁 فوروارد", "callback_data" => "forward_all"]],
        [["text" => "🚫 بلاک", "callback_data" => "block_user"], ["text" => "✅ آنبلاک", "callback_data" => "unblock_user"]],
        [["text" => "🟢 روشن", "callback_data" => "bot_on"], ["text" => "🔴 خاموش", "callback_data" => "bot_off"]],
        [["text" => "👨‍💻 Developer", "url" => "https://t.me/mrsilvon"]],
        [["text" => "🔙 بازگشت", "callback_data" => "back_to_home"]],
    ], true);
}


function saveUser($chatId)
{
    $users = file_exists('users.txt') ? file('users.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
    if (!in_array($chatId, $users)) {
        file_put_contents('users.txt', $chatId . PHP_EOL, FILE_APPEND);
    }
}

function downloadFile($url)
{
    $tempFile = tempnam(sys_get_temp_dir(), 'video_') . '.mp4';

    $ch = curl_init($url);
    $fp = fopen($tempFile, 'w+');
    curl_setopt($ch, CURLOPT_FILE, $fp);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_FAILONERROR, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    $success = curl_exec($ch);
    curl_close($ch);
    fclose($fp);

    if ($success) {
        return $tempFile;
    } else {
        if (file_exists($tempFile)) unlink($tempFile);
        return false;
    }
}

function sendMessage($chatId, $text, $keyboard = null, $isInline = false)
{
    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/sendMessage";

    $postData = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true,
    ];

    if ($keyboard !== null) {
        if ($isInline) {
            $postData['reply_markup'] = json_encode(['inline_keyboard' => $keyboard]);
        } else {
            $postData['reply_markup'] = json_encode(['keyboard' => $keyboard, 'resize_keyboard' => true]);
        }
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

function sendVideoFile($chatId, $filePath, $caption = '')
{
    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/sendVideo";

    $postFields = [
        'chat_id' => $chatId,
        'video' => new CURLFile($filePath),
        'caption' => $caption,        // اضافه کردن کپشن
        'parse_mode' => 'HTML'        // برای پشتیبانی از HTML در کپشن
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);

    return $result;
}


function answerCallbackQuery($callbackQueryId, $text = '')
{
    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/answerCallbackQuery";
    $postData = [
        'callback_query_id' => $callbackQueryId,
        'text' => $text,
        'show_alert' => false
    ];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

function forwardMessage($toChatId, $fromChatId, $messageId)
{
    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/forwardMessage";
    $postData = [
        'chat_id' => $toChatId,
        'from_chat_id' => $fromChatId,
        'message_id' => $messageId,
    ];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

function isUserJoined($chatId, $channelUsername)
{
    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/getChatMember?chat_id=$channelUsername&user_id=$chatId";
    $result = json_decode(file_get_contents($url), true);

    if (!isset($result['ok']) || !$result['ok']) {
        return false;
    }

    $status = $result['result']['status'];
    return in_array($status, ['member', 'creator', 'administrator']);
}

